**-- DAO
*-- MessageBox parameters
#DEFINE MB_OK                   0       && OK button only
#DEFINE MB_OKCANCEL             1       && OK and Cancel buttons
#DEFINE MB_ABORTRETRYIGNORE     2       && Abort, Retry, and Ignore buttons
#DEFINE MB_YESNOCANCEL          3       && Yes, No, and Cancel buttons
#DEFINE MB_YESNO                4       && Yes and No buttons
#DEFINE MB_RETRYCANCEL          5       && Retry and Cancel buttons

#DEFINE MB_ICONSTOP             16      && Critical message
#DEFINE MB_ICONQUESTION         32      && Warning query
#DEFINE MB_ICONEXCLAMATION      48      && Warning message
#DEFINE MB_ICONINFORMATION      64      && Information message

#DEFINE MB_APPLMODAL            0       && Application modal message box
#DEFINE MB_DEFBUTTON1           0       && First button is default
#DEFINE MB_DEFBUTTON2           256     && Second button is default
#DEFINE MB_DEFBUTTON3           512     && Third button is default
#DEFINE MB_SYSTEMMODAL          4096    && System Modal

*-- MsgBox return values
#DEFINE IDOK            1       && OK button pressed
#DEFINE IDCANCEL        2       && Cancel button pressed
#DEFINE IDABORT         3       && Abort button pressed
#DEFINE IDRETRY         4       && Retry button pressed
#DEFINE IDIGNORE        5       && Ignore button pressed
#DEFINE IDYES           6       && Yes button pressed
#DEFINE IDNO            7       && No button pressed

#DEFINE PHONE_ERROR_DEVICE	0xFFFFFFFE
#DEFINE MONITORSILENCE_TAG	0x89ABCDEF
#DEFINE TAPIREPLYTIMEOUT	0xFFFFFFFD

#DEFINE NOT_TAPI_COMPLIANT	0xFFFFFC27
#DEFINE LICENSE_EXCEEDED	0xFFFFFC26
#DEFINE LICENSE_EXCEEDED_TS	0xFFFFFC25
#DEFINE INVALID_SERIAL_NUMBER	0xFFFFFC24

#DEFINE WAVE_FORMAT_PCM  0x1
#DEFINE WAVE_FORMAT_ALAW  0x6
#DEFINE WAVE_FORMAT_MULAW  0x7
#DEFINE WAVE_FORMAT_DVI_ADPCM  0x11
#DEFINE WAVE_FORMAT_IMA_ADPCM  WAVE_FORMAT_DVI_ADPCM
#DEFINE WAVE_FORMAT_DIALOGIC_OKI_ADPCM  0x17

#DEFINE WAV_ERROR_NONE  0
#DEFINE WAV_ERROR_NOFILE  -1
#DEFINE WAV_ERROR_FILEOPEN  -2
#DEFINE WAV_ERROR_FILECORRUPT  -3
#DEFINE WAV_ERROR_FILEREAD  -4
#DEFINE WAV_ERROR_FILEWRITE  -5
#DEFINE WAV_ERROR_NOMEMORY  -6
#DEFINE WAV_ERROR_UNSUPPORTEDFORMAT  -7
#DEFINE WAV_ERROR_DEVICE  -8
#DEFINE WAV_ERROR_CANCELED  -9
#DEFINE WAV_ERROR_FILETOOBIG  -10
#DEFINE WAV_ERROR_INVALIDVOLUME  -11
#DEFINE WAV_ERROR_FORMATMISMATCH  -12

#DEFINE wfCOUNT  24
#DEFINE wfPCM08000M08  0
#DEFINE wfPCM08000S08  1
#DEFINE wfPCM08000M16  2
#DEFINE wfPCM08000S16  3
#DEFINE wfPCM11025M08  4
#DEFINE wfPCM11025S08  5
#DEFINE wfPCM11025M16  6
#DEFINE wfPCM11025S16  7
#DEFINE wfPCM22050M08  8
#DEFINE wfPCM22050S08  9
#DEFINE wfPCM22050M16  11
#DEFINE wfPCM22050S16  12
#DEFINE wfPCM44100M08  13
#DEFINE wfPCM44100S08  14
#DEFINE wfPCM44100M16  15
#DEFINE wfPCM44100S16  16
#DEFINE wfuLaw06000M08  17
#DEFINE wfuLaw08000M08  18
#DEFINE wfADPCM06000M04  19
#DEFINE wfADPCM08000M04  20
#DEFINE wfIMAADPCM04800M04  21
#DEFINE wfIMAADPCM07200M04  22
#DEFINE wfIMAADPCM08000M04  23

#DEFINE SwfPCM08000M08  "PCM 8,000 Hz, 8-bit, Mono"
#DEFINE SwfPCM08000S08  "PCM 8,000 Hz, 8-bit, Stereo"
#DEFINE SwfPCM08000M16  "PCM 8,000 Hz, 16-bit, Mono"
#DEFINE SwfPCM08000S16  "PCM 8,000 Hz, 16-bit, Stereo"
#DEFINE SwfPCM11025M08  "PCM 11,025 Hz, 8-bit, Mono"
#DEFINE SwfPCM11025S08  "PCM 11,025 Hz, 8-bit, Stereo"
#DEFINE SwfPCM11025M16  "PCM 11,025 Hz, 16-bit, Mono"
#DEFINE SwfPCM11025S16  "PCM 11,025 Hz, 16-bit, Stereo"
#DEFINE SwfPCM22050M08  "PCM 22,050 Hz, 8-bit, Mono"
#DEFINE SwfPCM22050S08  "PCM 22,050 Hz, 8-bit, Stereo"
#DEFINE SwfPCM22050M16  "PCM 22,050 Hz, 16-bit, Mono"
#DEFINE SwfPCM22050S16  "PCM 22,050 Hz, 16-bit, Stereo"
#DEFINE SwfPCM44100M08  "PCM 44,100 Hz, 8-bit, Mono"
#DEFINE SwfPCM44100S08  "PCM 44,100 Hz, 8-bit, Stereo"
#DEFINE SwfPCM44100M16  "PCM 44,100 Hz, 16-bit, Mono"
#DEFINE SwfPCM44100S16  "PCM 44,100 Hz, 16-bit, Stereo"
#DEFINE SwfuLaw06000M08  "uLaw 6,000 Hz, 8-bit, Mono"
#DEFINE SwfuLaw08000M08  "uLaw 8,000 Hz, 8-bit, Mono"
#DEFINE SwfADPCM06000M04  "ADPCM 6,000 Hz, 4-bit, Mono"
#DEFINE SwfADPCM08000M04  "ADPCM 8,000 Hz, 4-bit, Mono"
#DEFINE SwfIMAADPCM04800M04  "IMA_ADPCM 4,800 Hz, 4-bit, Mono"
#DEFINE SwfIMAADPCM07200M04  "IMA_ADPCM 7,200 Hz, 4-bit, Mono"
#DEFINE SwfIMAADPCM08000M04  "IMA_ADPCM 8,000 Hz, 4-bit, Mono"

#DEFINE TAPI_VERSION_MIN  0x10003
#DEFINE TAPI_VERSION_MAX  0x10004

#DEFINE CALL_INBOUND  0
#DEFINE CALL_OUTBOUND  1

*Messages for Phones and Lines
#DEFINE LINE_ADDRESSSTATE  0
#DEFINE LINE_CALLINFO  1
#DEFINE LINE_CALLSTATE  2
#DEFINE LINE_CLOSE  3
#DEFINE LINE_DEVSPECIFIC  4
#DEFINE LINE_DEVSPECIFICFEATURE  5
#DEFINE LINE_GATHERDIGITS  6
#DEFINE LINE_GENERATE  7
#DEFINE LINE_LINEDEVSTATE  8
#DEFINE LINE_MONITORDIGITS  9
#DEFINE LINE_MONITORMEDIA  10
#DEFINE LINE_MONITORTONE  11
#DEFINE LINE_REPLY  12
#DEFINE LINE_REQUEST  13
#DEFINE PHONE_BUTTON  14
#DEFINE PHONE_CLOSE  15
#DEFINE PHONE_DEVSPECIFIC  16
#DEFINE PHONE_REPLY  17
#DEFINE PHONE_STATE  18
#DEFINE LINE_CREATE  19
#DEFINE PHONE_CREATE  20

*Define Simple Telephony Constants
#DEFINE TAPIERR_CONNECTED  0x0
#DEFINE TAPIERR_DROPPED  0xFFFF
#DEFINE TAPIERR_NOREQUESTRECIPIENT  0xFFFE
#DEFINE TAPIERR_REQUESTQUEUEFULL  0xFFFD
#DEFINE TAPIERR_INVALDESTADDRESS  0xFFFC
#DEFINE TAPIERR_INVALWINDOWHANDLE  0xFFFB
#DEFINE TAPIERR_INVALDEVICECLASS  0xFFFA
#DEFINE TAPIERR_INVALDEVICEID  0xFFF9
#DEFINE TAPIERR_DEVICECLASSUNAVAIL  0xFFF8
#DEFINE TAPIERR_DEVICEIDUNAVAIL  0xFFF7
#DEFINE TAPIERR_DEVICEINUSE  0xFFF6
#DEFINE TAPIERR_DESTBUSY  0xFFF5
#DEFINE TAPIERR_DESTNOANSWER  0xFFF4
#DEFINE TAPIERR_DESTUNAVAIL  0xFFF3
#DEFINE TAPIERR_UNKNOWNWINHANDLE  0xFFF2
#DEFINE TAPIERR_UNKNOWNREQUESTID  0xFFF1
#DEFINE TAPIERR_REQUESTFAILED  0xFFF0
#DEFINE TAPIERR_REQUESTCANCELLED  0xFFEF
#DEFINE TAPIERR_INVALPOINTER  0xFFEE

#DEFINE TAPIMAXDESTADDRESSSIZE  80
#DEFINE TAPIMAXAPPNAMESIZE  40
#DEFINE TAPIMAXCALLEDPARTYSIZE  40
#DEFINE TAPIMAXCOMMENTSIZE  80
#DEFINE TAPIMAXDEVICECLASSSIZE  40
#DEFINE TAPIMAXDEVICEIDSIZE  40

*Data types and values for Phones
#DEFINE PHONEBUTTONFUNCTION_UNKNOWN  0x0
#DEFINE PHONEBUTTONFUNCTION_CONFERENCE  0x1
#DEFINE PHONEBUTTONFUNCTION_TRANSFER  0x2
#DEFINE PHONEBUTTONFUNCTION_DROP  0x3
#DEFINE PHONEBUTTONFUNCTION_HOLD  0x4
#DEFINE PHONEBUTTONFUNCTION_RECALL  0x5
#DEFINE PHONEBUTTONFUNCTION_DISCONNECT  0x6
#DEFINE PHONEBUTTONFUNCTION_CONNECT  0x7
#DEFINE PHONEBUTTONFUNCTION_MSGWAITON  0x8
#DEFINE PHONEBUTTONFUNCTION_MSGWAITOFF  0x9
#DEFINE PHONEBUTTONFUNCTION_SELECTRING  0xA
#DEFINE PHONEBUTTONFUNCTION_ABBREVDIAL  0xB
#DEFINE PHONEBUTTONFUNCTION_FORWARD  0xC
#DEFINE PHONEBUTTONFUNCTION_PICKUP  0xD
#DEFINE PHONEBUTTONFUNCTION_RINGAGAIN  0xE
#DEFINE PHONEBUTTONFUNCTION_PARK  0xF
#DEFINE PHONEBUTTONFUNCTION_REJECT  0x10
#DEFINE PHONEBUTTONFUNCTION_REDIRECT  0x11
#DEFINE PHONEBUTTONFUNCTION_MUTE  0x12
#DEFINE PHONEBUTTONFUNCTION_VOLUMEUP  0x13
#DEFINE PHONEBUTTONFUNCTION_VOLUMEDOWN  0x14
#DEFINE PHONEBUTTONFUNCTION_SPEAKERON  0x15
#DEFINE PHONEBUTTONFUNCTION_SPEAKEROFF  0x16
#DEFINE PHONEBUTTONFUNCTION_FLASH  0x17
#DEFINE PHONEBUTTONFUNCTION_DATAON  0x18
#DEFINE PHONEBUTTONFUNCTION_DATAOFF  0x19
#DEFINE PHONEBUTTONFUNCTION_DONOTDISTURB  0x1A
#DEFINE PHONEBUTTONFUNCTION_INTERCOM  0x1B
#DEFINE PHONEBUTTONFUNCTION_BRIDGEDAPP  0x1C
#DEFINE PHONEBUTTONFUNCTION_BUSY  0x1D
#DEFINE PHONEBUTTONFUNCTION_CALLAPP  0x1E
#DEFINE PHONEBUTTONFUNCTION_DATETIME  0x1F
#DEFINE PHONEBUTTONFUNCTION_DIRECTORY  0x20
#DEFINE PHONEBUTTONFUNCTION_COVER  0x21
#DEFINE PHONEBUTTONFUNCTION_CALLID  0x22
#DEFINE PHONEBUTTONFUNCTION_LASTNUM  0x23
#DEFINE PHONEBUTTONFUNCTION_NIGHTSRV  0x24
#DEFINE PHONEBUTTONFUNCTION_SENDCALLS  0x25
#DEFINE PHONEBUTTONFUNCTION_MSGINDICATOR  0x26
#DEFINE PHONEBUTTONFUNCTION_REPDIAL  0x27
#DEFINE PHONEBUTTONFUNCTION_SETREPDIAL  0x28
#DEFINE PHONEBUTTONFUNCTION_SYSTEMSPEED  0x29
#DEFINE PHONEBUTTONFUNCTION_STATIONSPEED  0x2A
#DEFINE PHONEBUTTONFUNCTION_CAMPON  0x2B
#DEFINE PHONEBUTTONFUNCTION_SAVEREPEAT  0x2C
#DEFINE PHONEBUTTONFUNCTION_QUEUECALL  0x2D
#DEFINE PHONEBUTTONFUNCTION_NONE  0x2E

#DEFINE PHONEBUTTONMODE_DUMMY  0x1
#DEFINE PHONEBUTTONMODE_CALL  0x2
#DEFINE PHONEBUTTONMODE_FEATURE  0x4
#DEFINE PHONEBUTTONMODE_KEYPAD  0x8
#DEFINE PHONEBUTTONMODE_LOCAL  0x10
#DEFINE PHONEBUTTONMODE_DISPLAY  0x20

#DEFINE PHONEBUTTONSTATE_UP  0x1
#DEFINE PHONEBUTTONSTATE_DOWN  0x2
#DEFINE PHONEBUTTONSTATE_UNKNOWN  0x4
#DEFINE PHONEBUTTONSTATE_UNAVAIL  0x8

#DEFINE PHONEERR_ALLOCATED  0x90000001
#DEFINE PHONEERR_BADDEVICEID  0x90000002
#DEFINE PHONEERR_INCOMPATIBLEAPIVERSION  0x90000003
#DEFINE PHONEERR_INCOMPATIBLEEXTVERSION  0x90000004
#DEFINE PHONEERR_INIFILECORRUPT  0x90000005
#DEFINE PHONEERR_INUSE  0x90000006
#DEFINE PHONEERR_INVALAPPHANDLE  0x90000007
#DEFINE PHONEERR_INVALAPPNAME  0x90000008
#DEFINE PHONEERR_INVALBUTTONLAMPID  0x90000009
#DEFINE PHONEERR_INVALBUTTONMODE  0x9000000A
#DEFINE PHONEERR_INVALBUTTONSTATE  0x9000000B
#DEFINE PHONEERR_INVALDATAID  0x9000000C
#DEFINE PHONEERR_INVALDEVICECLASS  0x9000000D
#DEFINE PHONEERR_INVALEXTVERSION  0x9000000E
#DEFINE PHONEERR_INVALHOOKSWITCHDEV  0x9000000F
#DEFINE PHONEERR_INVALHOOKSWITCHMODE  0x90000010
#DEFINE PHONEERR_INVALLAMPMODE  0x90000011
#DEFINE PHONEERR_INVALPARAM  0x90000012
#DEFINE PHONEERR_INVALPHONEHANDLE  0x90000013
#DEFINE PHONEERR_INVALPHONESTATE  0x90000014
#DEFINE PHONEERR_INVALPOINTER  0x90000015
#DEFINE PHONEERR_INVALPRIVILEGE  0x90000016
#DEFINE PHONEERR_INVALRINGMODE  0x90000017
#DEFINE PHONEERR_NODEVICE  0x90000018
#DEFINE PHONEERR_NODRIVER  0x90000019
#DEFINE PHONEERR_NOMEM  0x9000001A
#DEFINE PHONEERR_NOTOWNER  0x9000001B
#DEFINE PHONEERR_OPERATIONFAILED  0x9000001C
#DEFINE PHONEERR_OPERATIONUNAVAIL  0x9000001D
#DEFINE PHONEERR_RESOURCEUNAVAIL  0x9000001F
#DEFINE PHONEERR_REQUESTOVERRUN  0x90000020
#DEFINE PHONEERR_STRUCTURETOOSMALL  0x90000021
#DEFINE PHONEERR_UNINITIALIZED  0x90000022
#DEFINE PHONEERR_REINIT  0x90000023

#DEFINE PHONEHOOKSWITCHDEV_HANDSET  0x1
#DEFINE PHONEHOOKSWITCHDEV_SPEAKER  0x2
#DEFINE PHONEHOOKSWITCHDEV_HEADSET  0x4

#DEFINE PHONEHOOKSWITCHMODE_ONHOOK  0x1
#DEFINE PHONEHOOKSWITCHMODE_MIC  0x2
#DEFINE PHONEHOOKSWITCHMODE_SPEAKER  0x4
#DEFINE PHONEHOOKSWITCHMODE_MICSPEAKER  0x8
#DEFINE PHONEHOOKSWITCHMODE_UNKNOWN  0x10

#DEFINE PHONELAMPMODE_DUMMY  0x1
#DEFINE PHONELAMPMODE_OFF  0x2
#DEFINE PHONELAMPMODE_STEADY  0x4
#DEFINE PHONELAMPMODE_WINK  0x8
#DEFINE PHONELAMPMODE_FLASH  0x10
#DEFINE PHONELAMPMODE_FLUTTER  0x20
#DEFINE PHONELAMPMODE_BROKENFLUTTER  0x40
#DEFINE PHONELAMPMODE_UNKNOWN  0x80

#DEFINE PHONEPRIVILEGE_MONITOR  0x1
#DEFINE PHONEPRIVILEGE_OWNER  0x2

#DEFINE PHONESTATE_OTHER  0x1
#DEFINE PHONESTATE_CONNECTED  0x2
#DEFINE PHONESTATE_DISCONNECTED  0x4
#DEFINE PHONESTATE_OWNER  0x8
#DEFINE PHONESTATE_MONITORS  0x10
#DEFINE PHONESTATE_DISPLAY  0x20
#DEFINE PHONESTATE_LAMP  0x40
#DEFINE PHONESTATE_RINGMODE  0x80
#DEFINE PHONESTATE_RINGVOLUME  0x100
#DEFINE PHONESTATE_HANDSETHOOKSWITCH  0x200
#DEFINE PHONESTATE_HANDSETVOLUME  0x400
#DEFINE PHONESTATE_HANDSETGAIN  0x800
#DEFINE PHONESTATE_SPEAKERHOOKSWITCH  0x1000
#DEFINE PHONESTATE_SPEAKERVOLUME  0x2000
#DEFINE PHONESTATE_SPEAKERGAIN  0x4000
#DEFINE PHONESTATE_HEADSETHOOKSWITCH  0x8000
#DEFINE PHONESTATE_HEADSETVOLUME  0x10000
#DEFINE PHONESTATE_HEADSETGAIN  0x20000
#DEFINE PHONESTATE_SUSPEND  0x40000
#DEFINE PHONESTATE_RESUME  0x80000
#DEFINE PHONESTATE_DEVSPECIFIC  0x100000
#DEFINE PHONESTATE_REINIT  0x200000
#DEFINE PHONESTATE_CAPSCHANGE  0x400000
#DEFINE PHONESTATE_REMOVED  0x800000

#DEFINE PHONESTATUSFLAGS_CONNECTED  0x1
#DEFINE PHONESTATUSFLAGS_SUSPENDED  0x2

#DEFINE STRINGFORMAT_ASCII  0x1
#DEFINE STRINGFORMAT_DBCS  0x2
#DEFINE STRINGFORMAT_UNICODE  0x3
#DEFINE STRINGFORMAT_BINARY  0x4

*Data types and values for Lines
#DEFINE LINEADDRCAPFLAGS_FWDNUMRINGS  0x1
#DEFINE LINEADDRCAPFLAGS_PICKUPGROUPID  0x2
#DEFINE LINEADDRCAPFLAGS_SECURE  0x4
#DEFINE LINEADDRCAPFLAGS_BLOCKIDDEFAULT  0x8
#DEFINE LINEADDRCAPFLAGS_BLOCKIDOVERRIDE  0x10
#DEFINE LINEADDRCAPFLAGS_DIALED  0x20
#DEFINE LINEADDRCAPFLAGS_ORIGOFFHOOK  0x40
#DEFINE LINEADDRCAPFLAGS_DESTOFFHOOK  0x80
#DEFINE LINEADDRCAPFLAGS_FWDCONSULT  0x100
#DEFINE LINEADDRCAPFLAGS_SETUPCONFNULL  0x200
#DEFINE LINEADDRCAPFLAGS_AUTORECONNECT  0x400
#DEFINE LINEADDRCAPFLAGS_COMPLETIONID  0x800
#DEFINE LINEADDRCAPFLAGS_TRANSFERHELD  0x1000
#DEFINE LINEADDRCAPFLAGS_TRANSFERMAKE  0x2000
#DEFINE LINEADDRCAPFLAGS_CONFERENCEHELD  0x4000
#DEFINE LINEADDRCAPFLAGS_CONFERENCEMAKE  0x8000
#DEFINE LINEADDRCAPFLAGS_PARTIALDIAL  0x10000
#DEFINE LINEADDRCAPFLAGS_FWDSTATUSVALID  0x20000
#DEFINE LINEADDRCAPFLAGS_FWDINTEXTADDR  0x40000
#DEFINE LINEADDRCAPFLAGS_FWDBUSYNAADDR  0x80000
#DEFINE LINEADDRCAPFLAGS_ACCEPTTOALERT  0x100000
#DEFINE LINEADDRCAPFLAGS_CONFDROP  0x200000
#DEFINE LINEADDRCAPFLAGS_PICKUPCALLWAIT  0x400000
#DEFINE LINEADDRCAPFLAGS_PREDICTIVEDIALER  0x800000 &&TAPI v2.0
#DEFINE LINEADDRCAPFLAGS_QUEUE  0x1000000 &&TAPI v2.0
#DEFINE LINEADDRCAPFLAGS_ROUTEPOINT  0x2000000 &&TAPI v2.0
#DEFINE LINEADDRCAPFLAGS_HOLDMAKESNEW  0x4000000 &&TAPI v2.0
#DEFINE LINEADDRCAPFLAGS_NOINTERNALCALLS  0x8000000 &&TAPI v2.0
#DEFINE LINEADDRCAPFLAGS_NOEXTERNALCALLS  0x10000000 &&TAPI v2.0
#DEFINE LINEADDRCAPFLAGS_SETCALLINGID  0x20000000 &&TAPI v2.0
#DEFINE LINEADDRCAPFLAGS_ACDGROUP  0x40000000 &&TAPI 3.0

#DEFINE LINEADDRESSMODE_ADDRESSID  0x1
#DEFINE LINEADDRESSMODE_DIALABLEADDR  0x2

#DEFINE LINEADDRESSSHARING_PRIVATE  0x1
#DEFINE LINEADDRESSSHARING_BRIDGEDEXCL  0x2
#DEFINE LINEADDRESSSHARING_BRIDGEDNEW  0x4
#DEFINE LINEADDRESSSHARING_BRIDGEDSHARED  0x8
#DEFINE LINEADDRESSSHARING_MONITORED  0x10

#DEFINE LINEADDRESSSTATE_OTHER  0x1
#DEFINE LINEADDRESSSTATE_DEVSPECIFIC  0x2
#DEFINE LINEADDRESSSTATE_INUSEZERO  0x4
#DEFINE LINEADDRESSSTATE_INUSEONE  0x8
#DEFINE LINEADDRESSSTATE_INUSEMANY  0x10
#DEFINE LINEADDRESSSTATE_NUMCALLS  0x20
#DEFINE LINEADDRESSSTATE_FORWARD  0x40
#DEFINE LINEADDRESSSTATE_TERMINALS  0x80
#DEFINE LINEADDRESSSTATE_CAPSCHANGE  0x100

#DEFINE LINEADDRESSTYPE_PHONENUMBER  0x1 &&TAPI 3.0
#DEFINE LINEADDRESSTYPE_SDP  0x2 &&TAPI 3.0
#DEFINE LINEADDRESSTYPE_EMAILNAME  0x4 &&TAPI 3.0
#DEFINE LINEADDRESSTYPE_DOMAINNAME  0x8 &&TAPI 3.0
#DEFINE LINEADDRESSTYPE_IPADDRESS  0x10 &&TAPI 3.0

#DEFINE LINEADDRFEATURE_FORWARD  0x1
#DEFINE LINEADDRFEATURE_MAKECALL  0x2
#DEFINE LINEADDRFEATURE_PICKUP  0x4
#DEFINE LINEADDRFEATURE_SETMEDIACONTROL  0x8
#DEFINE LINEADDRFEATURE_SETTERMINAL  0x10
#DEFINE LINEADDRFEATURE_SETUPCONF  0x20
#DEFINE LINEADDRFEATURE_UNCOMPLETECALL  0x40
#DEFINE LINEADDRFEATURE_UNPARK  0x80

#DEFINE LINEADDRFEATURE_PICKUPHELD  0x100 && TAPI v2.0
#DEFINE LINEADDRFEATURE_PICKUPGROUP  0x200 && TAPI v2.0
#DEFINE LINEADDRFEATURE_PICKUPDIRECT  0x400 && TAPI v2.0
#DEFINE LINEADDRFEATURE_PICKUPWAITING  0x800 && TAPI v2.0
#DEFINE LINEADDRFEATURE_FORWARDFWD  0x1000 && TAPI v2.0
#DEFINE LINEADDRFEATURE_FORWARDDND  0x2000 && TAPI v2.0

#DEFINE LINEAGENTFEATURE_SETAGENTGROUP  0x1 && TAPI v2.0
#DEFINE LINEAGENTFEATURE_SETAGENTSTATE  0x2 && TAPI v2.0
#DEFINE LINEAGENTFEATURE_SETAGENTACTIVITY  0x4 && TAPI v2.0
#DEFINE LINEAGENTFEATURE_AGENTSPECIFIC  0x8 && TAPI v2.0
#DEFINE LINEAGENTFEATURE_GETAGENTACTIVITYLIST  0x10 && TAPI v2.0
#DEFINE LINEAGENTFEATURE_GETAGENTGROUP  0x20 && TAPI v2.0

#DEFINE LINEAGENTSTATE_LOGGEDOFF  0x1 && TAPI v2.0
#DEFINE LINEAGENTSTATE_NOTREADY  0x2 && TAPI v2.0
#DEFINE LINEAGENTSTATE_READY  0x4 && TAPI v2.0
#DEFINE LINEAGENTSTATE_BUSYACD  0x8 && TAPI v2.0
#DEFINE LINEAGENTSTATE_BUSYINCOMING  0x10 && TAPI v2.0
#DEFINE LINEAGENTSTATE_BUSYOUTBOUND  0x20 && TAPI v2.0
#DEFINE LINEAGENTSTATE_BUSYOTHER  0x40 && TAPI v2.0
#DEFINE LINEAGENTSTATE_WORKINGAFTERCALL  0x80 && TAPI v2.0
#DEFINE LINEAGENTSTATE_UNKNOWN  0x100 && TAPI v2.0
#DEFINE LINEAGENTSTATE_UNAVAIL  0x200 && TAPI v2.0

#DEFINE LINEAGENTSTATUS_GROUP  0x1 && TAPI v2.0
#DEFINE LINEAGENTSTATUS_STATE  0x2 && TAPI v2.0
#DEFINE LINEAGENTSTATUS_NEXTSTATE  0x4 && TAPI v2.0
#DEFINE LINEAGENTSTATUS_ACTIVITY  0x8 && TAPI v2.0
#DEFINE LINEAGENTSTATUS_ACTIVITYLIST  0x10 && TAPI v2.0
#DEFINE LINEAGENTSTATUS_GROUPLIST  0x20 && TAPI v2.0
#DEFINE LINEAGENTSTATUS_CAPSCHANGE  0x40 && TAPI v2.0
#DEFINE LINEAGENTSTATUS_VALIDSTATES  0x80 && TAPI v2.0
#DEFINE LINEAGENTSTATUS_VALIDNEXTSTATES  0x100 && TAPI v2.0

#DEFINE LINEAGENTSTATEEX_NOTREADY  0x1 && TAPI v3.0
#DEFINE LINEAGENTSTATEEX_READY  0x2 && TAPI v3.0
#DEFINE LINEAGENTSTATEEX_BUSYACD  0x4 && TAPI v3.0
#DEFINE LINEAGENTSTATEEX_BUSYINCOMING  0x8 && TAPI v3.0
#DEFINE LINEAGENTSTATEEX_BUSYOUTGOING  0x10 && TAPI v3.0
#DEFINE LINEAGENTSTATEEX_UNKNOWN  0x20 && TAPI v3.0
#DEFINE LINEAGENTSTATEEX_RELEASED  0x40 && TAPI v3.0

#DEFINE LINEAGENTSTATUSEX_NEWAGENT  0x1 && TAPI v3.0
#DEFINE LINEAGENTSTATUSEX_STATE  0x2 && TAPI v3.0
#DEFINE LINEAGENTSTATUSEX_UPDATEINFO  0x3 && TAPI v3.0
#DEFINE LINEAGENTSTATUSEX_DESTROYED  0x4 && TAPI v3.0

#DEFINE LINEAGENTSESSIONSTATE_NOTREADY  0x1 && TAPI v3.0
#DEFINE LINEAGENTSESSIONSTATE_READY  0x2 && TAPI v3.0
#DEFINE LINEAGENTSESSIONSTATE_BUSYONCALL  0x4 && TAPI v3.0
#DEFINE LINEAGENTSESSIONSTATE_BUSYWRAPUP  0x8 && TAPI v3.0
#DEFINE LINEAGENTSESSIONSTATE_ENDED  0x10 && TAPI v3.0
#DEFINE LINEAGENTSESSIONSTATE_RELEASED  0x20 && TAPI v3.0


#DEFINE LINEAGENTSESSIONSTATUS_NEWSESSION  0x1 && TAPI v3.0
#DEFINE LINEAGENTSESSIONSTATUS_STATE  0x2 && TAPI v3.0
#DEFINE LINEAGENTSESSIONSTATUS_UPDATEINFO  0x4 && TAPI v3.0
#DEFINE LINEAGENTSESSIONSTATUS_DESTROYED  0x8 && TAPI v3.0

#DEFINE LINEQUEUESTATUS_UPDATEINFO  0x1 && TAPI v3.0
#DEFINE LINEQUEUESTATUS_NEWQUEUE  0x2 && TAPI v3.0
#DEFINE LINEQUEUESTATUS_QUEUEREMOVED  0x4 && TAPI v3.0

#DEFINE LINEGROUPSTATUS_NEWGROUP  0x1 && TAPI v3.0
#DEFINE LINEGROUPSTATUS_GROUPREMOVED  0x2 && TAPI v3.0

#DEFINE LINEPROXYSTATUS_OPEN  0x1 && TAPI v3.0
#DEFINE LINEPROXYSTATUS_CLOSE  0x2 && TAPI v3.0
#DEFINE LINEPROXYSTATUS_ALLOPENFORACD  0x4 && TAPI v3.0

#DEFINE LINEANSWERMODE_NONE  0x1
#DEFINE LINEANSWERMODE_DROP  0x2
#DEFINE LINEANSWERMODE_HOLD  0x4

#DEFINE LINEBEARERMODE_VOICE  0x1
#DEFINE LINEBEARERMODE_SPEECH  0x2
#DEFINE LINEBEARERMODE_MULTIUSE  0x4
#DEFINE LINEBEARERMODE_DATA  0x8
#DEFINE LINEBEARERMODE_ALTSPEECHDATA  0x10
#DEFINE LINEBEARERMODE_NONCALLSIGNALING  0x20
#DEFINE LINEBEARERMODE_PASSTHROUGH  0x40
#DEFINE LINEBEARERMODE_RESTRICTEDDATA  0x80 && TAPI v2.0

#DEFINE LINEBUSYMODE_STATION  0x1
#DEFINE LINEBUSYMODE_TRUNK  0x2
#DEFINE LINEBUSYMODE_UNKNOWN  0x4
#DEFINE LINEBUSYMODE_UNAVAIL  0x8

#DEFINE LINECALLCOMPLCOND_BUSY  0x1
#DEFINE LINECALLCOMPLCOND_NOANSWER  0x2

#DEFINE LINECALLCOMPLMODE_CAMPON  0x1
#DEFINE LINECALLCOMPLMODE_CALLBACK  0x2
#DEFINE LINECALLCOMPLMODE_INTRUDE  0x4
#DEFINE LINECALLCOMPLMODE_MESSAGE  0x8

#DEFINE LINECALLFEATURE_ACCEPT  0x1
#DEFINE LINECALLFEATURE_ADDTOCONF  0x2
#DEFINE LINECALLFEATURE_ANSWER  0x4
#DEFINE LINECALLFEATURE_BLINDTRANSFER  0x8
#DEFINE LINECALLFEATURE_COMPLETECALL  0x10
#DEFINE LINECALLFEATURE_COMPLETETRANSF  0x20
#DEFINE LINECALLFEATURE_DIAL  0x40
#DEFINE LINECALLFEATURE_DROP  0x80
#DEFINE LINECALLFEATURE_GATHERDIGITS  0x100
#DEFINE LINECALLFEATURE_GENERATEDIGITS  0x200
#DEFINE LINECALLFEATURE_GENERATETONE  0x400
#DEFINE LINECALLFEATURE_HOLD  0x800
#DEFINE LINECALLFEATURE_MONITORDIGITS  0x1000
#DEFINE LINECALLFEATURE_MONITORMEDIA  0x2000
#DEFINE LINECALLFEATURE_MONITORTONES  0x4000
#DEFINE LINECALLFEATURE_PARK  0x8000
#DEFINE LINECALLFEATURE_PREPAREADDCONF  0x10000
#DEFINE LINECALLFEATURE_REDIRECT  0x20000
#DEFINE LINECALLFEATURE_REMOVEFROMCONF  0x40000
#DEFINE LINECALLFEATURE_SECURECALL  0x80000
#DEFINE LINECALLFEATURE_SENDUSERUSER  0x100000
#DEFINE LINECALLFEATURE_SETCALLPARAMS  0x200000
#DEFINE LINECALLFEATURE_SETMEDIACONTROL  0x400000
#DEFINE LINECALLFEATURE_SETTERMINAL  0x800000
#DEFINE LINECALLFEATURE_SETUPCONF  0x1000000
#DEFINE LINECALLFEATURE_SETUPTRANSFER  0x2000000
#DEFINE LINECALLFEATURE_SWAPHOLD  0x4000000
#DEFINE LINECALLFEATURE_UNHOLD  0x8000000
#DEFINE LINECALLFEATURE_RELEASEUSERUSERINFO  0x10000000
#DEFINE LINECALLFEATURE_SETTREATMENT  0x20000000 && TAPI v2.0
#DEFINE LINECALLFEATURE_SETQOS  0x40000000 && TAPI v2.0
#DEFINE LINECALLFEATURE_SETCALLDATA  0x80000000 && TAPI v2.0

#DEFINE LINECALLFEATURE2_NOHOLDCONFERENCE  0x1 && TAPI v2.0
#DEFINE LINECALLFEATURE2_ONESTEPTRANSFER  0x2 && TAPI v2.0
#DEFINE LINECALLFEATURE2_COMPLCAMPON  0x4 && TAPI v2.0
#DEFINE LINECALLFEATURE2_COMPLCALLBACK  0x8 && TAPI v2.0
#DEFINE LINECALLFEATURE2_COMPLINTRUDE  0x10 && TAPI v2.0
#DEFINE LINECALLFEATURE2_COMPLMESSAGE  0x20 && TAPI v2.0
#DEFINE LINECALLFEATURE2_TRANSFERNORM  0x40 && TAPI v2.0
#DEFINE LINECALLFEATURE2_TRANSFERCONF  0x80 && TAPI v2.0
#DEFINE LINECALLFEATURE2_PARKDIRECT  0x100 && TAPI v2.0
#DEFINE LINECALLFEATURE2_PARKNONDIRECT  0x200 && TAPI v2.0

#DEFINE LINECALLHUBTRACKING_NONE  0x0 && TAPI v3.0
#DEFINE LINECALLHUBTRACKING_PROVIDERLEVEL  0x1 && TAPI v3.0
#DEFINE LINECALLHUBTRACKING_ALLCALLS  0x2 && TAPI v3.0

#DEFINE LINECALLINFOSTATE_OTHER  0x1
#DEFINE LINECALLINFOSTATE_DEVSPECIFIC  0x2
#DEFINE LINECALLINFOSTATE_BEARERMODE  0x4
#DEFINE LINECALLINFOSTATE_RATE  0x8
#DEFINE LINECALLINFOSTATE_MEDIAMODE  0x10
#DEFINE LINECALLINFOSTATE_APPSPECIFIC  0x20
#DEFINE LINECALLINFOSTATE_CALLID  0x40
#DEFINE LINECALLINFOSTATE_RELATEDCALLID  0x80
#DEFINE LINECALLINFOSTATE_ORIGIN  0x100
#DEFINE LINECALLINFOSTATE_REASON  0x200
#DEFINE LINECALLINFOSTATE_COMPLETIONID  0x400
#DEFINE LINECALLINFOSTATE_NUMOWNERINCR  0x800
#DEFINE LINECALLINFOSTATE_NUMOWNERDECR  0x1000
#DEFINE LINECALLINFOSTATE_NUMMONITORS  0x2000
#DEFINE LINECALLINFOSTATE_TRUNK  0x4000
#DEFINE LINECALLINFOSTATE_CALLERID  0x8000
#DEFINE LINECALLINFOSTATE_CALLEDID  0x10000
#DEFINE LINECALLINFOSTATE_CONNECTEDID  0x20000
#DEFINE LINECALLINFOSTATE_REDIRECTIONID  0x40000
#DEFINE LINECALLINFOSTATE_REDIRECTINGID  0x80000
#DEFINE LINECALLINFOSTATE_DISPLAY  0x100000
#DEFINE LINECALLINFOSTATE_USERUSERINFO  0x200000
#DEFINE LINECALLINFOSTATE_HIGHLEVELCOMP  0x400000
#DEFINE LINECALLINFOSTATE_LOWLEVELCOMP  0x800000
#DEFINE LINECALLINFOSTATE_CHARGINGINFO  0x1000000
#DEFINE LINECALLINFOSTATE_TERMINAL  0x2000000
#DEFINE LINECALLINFOSTATE_DIALPARAMS  0x4000000
#DEFINE LINECALLINFOSTATE_MONITORMODES  0x8000000
#DEFINE LINECALLINFOSTATE_TREATMENT  0x10000000 && TAPI v2.0
#DEFINE LINECALLINFOSTATE_QOS  0x20000000 && TAPI v2.0
#DEFINE LINECALLINFOSTATE_CALLDATA  0x40000000 && TAPI v2.0

#DEFINE LINECALLORIGIN_OUTBOUND  0x1
#DEFINE LINECALLORIGIN_INTERNAL  0x2
#DEFINE LINECALLORIGIN_EXTERNAL  0x4
#DEFINE LINECALLORIGIN_UNKNOWN  0x10
#DEFINE LINECALLORIGIN_UNAVAIL  0x20
#DEFINE LINECALLORIGIN_CONFERENCE  0x40
#DEFINE LINECALLORIGIN_INBOUND  0x80

#DEFINE LINECALLPARAMFLAGS_SECURE  0x1
#DEFINE LINECALLPARAMFLAGS_IDLE  0x2
#DEFINE LINECALLPARAMFLAGS_BLOCKID  0x4
#DEFINE LINECALLPARAMFLAGS_ORIGOFFHOOK  0x8
#DEFINE LINECALLPARAMFLAGS_DESTOFFHOOK  0x10
#DEFINE LINECALLPARAMFLAGS_NOHOLDCONFERENCE  0x20 && TAPI v2.0
#DEFINE LINECALLPARAMFLAGS_PREDICTIVEDIAL  0x40 && TAPI v2.0
#DEFINE LINECALLPARAMFLAGS_ONESTEPTRANSFER  0x80 && TAPI v2.0

#DEFINE LINECALLPARTYID_BLOCKED  0x1
#DEFINE LINECALLPARTYID_OUTOFAREA  0x2
#DEFINE LINECALLPARTYID_NAME  0x4
#DEFINE LINECALLPARTYID_ADDRESS  0x8
#DEFINE LINECALLPARTYID_PARTIAL  0x10
#DEFINE LINECALLPARTYID_UNKNOWN  0x20
#DEFINE LINECALLPARTYID_UNAVAIL  0x40

#DEFINE LINECALLPRIVILEGE_NONE  0x1
#DEFINE LINECALLPRIVILEGE_MONITOR  0x2
#DEFINE LINECALLPRIVILEGE_OWNER  0x4

#DEFINE LINECALLREASON_DIRECT  0x1
#DEFINE LINECALLREASON_FWDBUSY  0x2
#DEFINE LINECALLREASON_FWDNOANSWER  0x4
#DEFINE LINECALLREASON_FWDUNCOND  0x8
#DEFINE LINECALLREASON_PICKUP  0x10
#DEFINE LINECALLREASON_UNPARK  0x20
#DEFINE LINECALLREASON_REDIRECT  0x40
#DEFINE LINECALLREASON_CALLCOMPLETION  0x80
#DEFINE LINECALLREASON_TRANSFER  0x100
#DEFINE LINECALLREASON_REMINDER  0x200
#DEFINE LINECALLREASON_UNKNOWN  0x400
#DEFINE LINECALLREASON_UNAVAIL  0x800
#DEFINE LINECALLREASON_INTRUDE  0x1000
#DEFINE LINECALLREASON_PARKED  0x2000
#DEFINE LINECALLREASON_CAMPEDON  0x4000 && TAPI v2.0
#DEFINE LINECALLREASON_ROUTEREQUEST  0x8000 && TAPI v2.0

#DEFINE LINECALLSELECT_LINE  0x1
#DEFINE LINECALLSELECT_ADDRESS  0x2
#DEFINE LINECALLSELECT_CALL  0x4

#DEFINE LINECALLSTATE_IDLE  0x1
#DEFINE LINECALLSTATE_OFFERING  0x2
#DEFINE LINECALLSTATE_ACCEPTED  0x4
#DEFINE LINECALLSTATE_DIALTONE  0x8
#DEFINE LINECALLSTATE_DIALING  0x10
#DEFINE LINECALLSTATE_RINGBACK  0x20
#DEFINE LINECALLSTATE_BUSY  0x40
#DEFINE LINECALLSTATE_SPECIALINFO  0x80
#DEFINE LINECALLSTATE_CONNECTED  0x100
#DEFINE LINECALLSTATE_PROCEEDING  0x200
#DEFINE LINECALLSTATE_ONHOLD  0x400
#DEFINE LINECALLSTATE_CONFERENCED  0x800
#DEFINE LINECALLSTATE_ONHOLDPENDCONF  0x1000
#DEFINE LINECALLSTATE_ONHOLDPENDTRANSF  0x2000
#DEFINE LINECALLSTATE_DISCONNECTED  0x4000
#DEFINE LINECALLSTATE_UNKNOWN  0x8000

#DEFINE LINECALLTREATMENT_SILENCE  0x1 && TAPI v2.0
#DEFINE LINECALLTREATMENT_RINGBACK  0x2 && TAPI v2.0
#DEFINE LINECALLTREATMENT_BUSY  0x3 && TAPI v2.0
#DEFINE LINECALLTREATMENT_MUSIC  0x4 && TAPI v2.0

#DEFINE LINECARDOPTION_PREDEFINED  0x1 && TAPI v1.4 NEW
#DEFINE LINECARDOPTION_HIDDEN  0x2 && TAPI v1.4 NEW

#DEFINE LINECONNECTEDMODE_ACTIVE  0x1
#DEFINE LINECONNECTEDMODE_INACTIVE  0x2
#DEFINE LINECONNECTEDMODE_ACTIVEHELD  0x4 && TAPI v2.0
#DEFINE LINECONNECTEDMODE_INACTIVEHELD  0x8 && TAPI v2.0
#DEFINE LINECONNECTEDMODE_CONFIRMED  0x10 && TAPI v2.0

#DEFINE LINEOFFERINGMODE_ACTIVE  0x1
#DEFINE LINEOFFERINGMODE_INACTIVE  0x2

#DEFINE LINEDEVCAPFLAGS_CROSSADDRCONF  0x1
#DEFINE LINEDEVCAPFLAGS_HIGHLEVCOMP  0x2
#DEFINE LINEDEVCAPFLAGS_LOWLEVCOMP  0x4
#DEFINE LINEDEVCAPFLAGS_MEDIACONTROL  0x8
#DEFINE LINEDEVCAPFLAGS_MULTIPLEADDR  0x10
#DEFINE LINEDEVCAPFLAGS_CLOSEDROP  0x20
#DEFINE LINEDEVCAPFLAGS_DIALBILLING  0x40
#DEFINE LINEDEVCAPFLAGS_DIALQUIET  0x80
#DEFINE LINEDEVCAPFLAGS_DIALDIALTONE  0x100
#DEFINE LINEDEVCAPFLAGS_MSP  0x200 && TAPI v3.0
#DEFINE LINEDEVCAPFLAGS_PARTICIPANTINFO  0x400 && TAPI v3.0
#DEFINE LINEDEVCAPFLAGS_CALLHUB  0x800 && TAPI v3.0
#DEFINE LINEDEVCAPFLAGS_CALLHUBTRACKING  0x1000 && TAPI v3.0
#DEFINE LINEDEVCAPFLAGS_PRIVATEOBJECTS  0x2000 && TAPI v3.0

#DEFINE LINEDEVSTATE_OTHER  0x1
#DEFINE LINEDEVSTATE_RINGING  0x2
#DEFINE LINEDEVSTATE_CONNECTED  0x4
#DEFINE LINEDEVSTATE_DISCONNECTED  0x8
#DEFINE LINEDEVSTATE_MSGWAITON  0x10
#DEFINE LINEDEVSTATE_MSGWAITOFF  0x20
#DEFINE LINEDEVSTATE_INSERVICE  0x40
#DEFINE LINEDEVSTATE_OUTOFSERVICE  0x80
#DEFINE LINEDEVSTATE_MAINTENANCE  0x100
#DEFINE LINEDEVSTATE_OPEN  0x200
#DEFINE LINEDEVSTATE_CLOSE  0x400
#DEFINE LINEDEVSTATE_NUMCALLS  0x800
#DEFINE LINEDEVSTATE_NUMCOMPLETIONS  0x1000
#DEFINE LINEDEVSTATE_TERMINALS  0x2000
#DEFINE LINEDEVSTATE_ROAMMODE  0x4000
#DEFINE LINEDEVSTATE_BATTERY  0x8000
#DEFINE LINEDEVSTATE_SIGNAL  0x10000
#DEFINE LINEDEVSTATE_DEVSPECIFIC  0x20000
#DEFINE LINEDEVSTATE_REINIT  0x40000
#DEFINE LINEDEVSTATE_LOCK  0x80000
#DEFINE LINEDEVSTATE_CAPSCHANGE  0x100000
#DEFINE LINEDEVSTATE_CONFIGCHANGE  0x200000
#DEFINE LINEDEVSTATE_TRANSLATECHANGE  0x400000
#DEFINE LINEDEVSTATE_COMPLCANCEL  0x800000
#DEFINE LINEDEVSTATE_REMOVED  0x1000000

#DEFINE LINEDEVSTATUSFLAGS_CONNECTED  0x1
#DEFINE LINEDEVSTATUSFLAGS_MSGWAIT  0x2
#DEFINE LINEDEVSTATUSFLAGS_INSERVICE  0x4
#DEFINE LINEDEVSTATUSFLAGS_LOCKED  0x8

#DEFINE LINEDIALTONEMODE_NORMAL  0x1
#DEFINE LINEDIALTONEMODE_SPECIAL  0x2
#DEFINE LINEDIALTONEMODE_INTERNAL  0x4
#DEFINE LINEDIALTONEMODE_EXTERNAL  0x8
#DEFINE LINEDIALTONEMODE_UNKNOWN  0x10
#DEFINE LINEDIALTONEMODE_UNAVAIL  0x20

#DEFINE LINEDIGITMODE_PULSE  0x1
#DEFINE LINEDIGITMODE_DTMF  0x2
#DEFINE LINEDIGITMODE_DTMFEND  0x4

#DEFINE LINEDISCONNECTMODE_NORMAL  0x1
#DEFINE LINEDISCONNECTMODE_UNKNOWN  0x2
#DEFINE LINEDISCONNECTMODE_REJECT  0x4
#DEFINE LINEDISCONNECTMODE_PICKUP  0x8
#DEFINE LINEDISCONNECTMODE_FORWARDED  0x10
#DEFINE LINEDISCONNECTMODE_BUSY  0x20
#DEFINE LINEDISCONNECTMODE_NOANSWER  0x40
#DEFINE LINEDISCONNECTMODE_BADADDRESS  0x80
#DEFINE LINEDISCONNECTMODE_UNREACHABLE  0x100
#DEFINE LINEDISCONNECTMODE_CONGESTION  0x200
#DEFINE LINEDISCONNECTMODE_INCOMPATIBLE  0x400
#DEFINE LINEDISCONNECTMODE_UNAVAIL  0x800
#DEFINE LINEDISCONNECTMODE_NODIALTONE  0x1000
#DEFINE LINEDISCONNECTMODE_NUMBERCHANGED  0x2000 && TAPI v2.0
#DEFINE LINEDISCONNECTMODE_OUTOFORDER  0x4000 && TAPI v2.0
#DEFINE LINEDISCONNECTMODE_TEMPFAILURE  0x8000 && TAPI v2.0
#DEFINE LINEDISCONNECTMODE_QOSUNAVAIL  0x10000 && TAPI v2.0
#DEFINE LINEDISCONNECTMODE_BLOCKED  0x20000 && TAPI v2.0
#DEFINE LINEDISCONNECTMODE_DONOTDISTURB  0x40000 && TAPI v2.0
#DEFINE LINEDISCONNECTMODE_CANCELLED  0x80000 && TAPI v2.0

#DEFINE LINE_ERROR_DEVICE  0xAAAAAAAA
#DEFINE LINEERR_ALLOCATED  0x80000001
#DEFINE LINEERR_BADDEVICEID  0x80000002
#DEFINE LINEERR_BEARERMODEUNAVAIL  0x80000003
#DEFINE LINEERR_CALLUNAVAIL  0x80000005
#DEFINE LINEERR_COMPLETIONOVERRUN  0x80000006
#DEFINE LINEERR_CONFERENCEFULL  0x80000007
#DEFINE LINEERR_DIALBILLING  0x80000008
#DEFINE LINEERR_DIALDIALTONE  0x80000009
#DEFINE LINEERR_DIALPROMPT  0x8000000A
#DEFINE LINEERR_DIALQUIET  0x8000000B
#DEFINE LINEERR_INCOMPATIBLEAPIVERSION  0x8000000C
#DEFINE LINEERR_INCOMPATIBLEEXTVERSION  0x8000000D
#DEFINE LINEERR_INIFILECORRUPT  0x8000000E
#DEFINE LINEERR_INUSE  0x8000000F
#DEFINE LINEERR_INVALADDRESS  0x80000010
#DEFINE LINEERR_INVALADDRESSID  0x80000011
#DEFINE LINEERR_INVALADDRESSMODE  0x80000012
#DEFINE LINEERR_INVALADDRESSSTATE  0x80000013
#DEFINE LINEERR_INVALAPPHANDLE  0x80000014
#DEFINE LINEERR_INVALAPPNAME  0x80000015
#DEFINE LINEERR_INVALBEARERMODE  0x80000016
#DEFINE LINEERR_INVALCALLCOMPLMODE  0x80000017
#DEFINE LINEERR_INVALCALLHANDLE  0x80000018
#DEFINE LINEERR_INVALCALLPARAMS  0x80000019
#DEFINE LINEERR_INVALCALLPRIVILEGE  0x8000001A
#DEFINE LINEERR_INVALCALLSELECT  0x8000001B
#DEFINE LINEERR_INVALCALLSTATE  0x8000001C
#DEFINE LINEERR_INVALCALLSTATELIST  0x8000001D
#DEFINE LINEERR_INVALCARD  0x8000001E
#DEFINE LINEERR_INVALCOMPLETIONID  0x8000001F
#DEFINE LINEERR_INVALCONFCALLHANDLE  0x80000020
#DEFINE LINEERR_INVALCONSULTCALLHANDLE  0x80000021
#DEFINE LINEERR_INVALCOUNTRYCODE  0x80000022
#DEFINE LINEERR_INVALDEVICECLASS  0x80000023
#DEFINE LINEERR_INVALDEVICEHANDLE  0x80000024
#DEFINE LINEERR_INVALDIALPARAMS  0x80000025
#DEFINE LINEERR_INVALDIGITLIST  0x80000026
#DEFINE LINEERR_INVALDIGITMODE  0x80000027
#DEFINE LINEERR_INVALDIGITS  0x80000028
#DEFINE LINEERR_INVALEXTVERSION  0x80000029
#DEFINE LINEERR_INVALGROUPID  0x8000002A
#DEFINE LINEERR_INVALLINEHANDLE  0x8000002B
#DEFINE LINEERR_INVALLINESTATE  0x8000002C
#DEFINE LINEERR_INVALLOCATION  0x8000002D
#DEFINE LINEERR_INVALMEDIALIST  0x8000002E
#DEFINE LINEERR_INVALMEDIAMODE  0x8000002F
#DEFINE LINEERR_INVALMESSAGEID  0x80000030
#DEFINE LINEERR_INVALPARAM  0x80000032
#DEFINE LINEERR_INVALPARKID  0x80000033
#DEFINE LINEERR_INVALPARKMODE  0x80000034
#DEFINE LINEERR_INVALPOINTER  0x80000035
#DEFINE LINEERR_INVALPRIVSELECT  0x80000036
#DEFINE LINEERR_INVALRATE  0x80000037
#DEFINE LINEERR_INVALREQUESTMODE  0x80000038
#DEFINE LINEERR_INVALTERMINALID  0x80000039
#DEFINE LINEERR_INVALTERMINALMODE  0x8000003A
#DEFINE LINEERR_INVALTIMEOUT  0x8000003B
#DEFINE LINEERR_INVALTONE  0x8000003C
#DEFINE LINEERR_INVALTONELIST  0x8000003D
#DEFINE LINEERR_INVALTONEMODE  0x8000003E
#DEFINE LINEERR_INVALTRANSFERMODE  0x8000003F
#DEFINE LINEERR_LINEMAPPERFAILED  0x80000040
#DEFINE LINEERR_NOCONFERENCE  0x80000041
#DEFINE LINEERR_NODEVICE  0x80000042
#DEFINE LINEERR_NODRIVER  0x80000043
#DEFINE LINEERR_NOMEM  0x80000044
#DEFINE LINEERR_NOREQUEST  0x80000045
#DEFINE LINEERR_NOTOWNER  0x80000046
#DEFINE LINEERR_NOTREGISTERED  0x80000047
#DEFINE LINEERR_OPERATIONFAILED  0x80000048
#DEFINE LINEERR_OPERATIONUNAVAIL  0x80000049
#DEFINE LINEERR_RATEUNAVAIL  0x8000004A
#DEFINE LINEERR_RESOURCEUNAVAIL  0x8000004B
#DEFINE LINEERR_REQUESTOVERRUN  0x8000004C
#DEFINE LINEERR_STRUCTURETOOSMALL  0x8000004D
#DEFINE LINEERR_TARGETNOTFOUND  0x8000004E
#DEFINE LINEERR_TARGETSELF  0x8000004F
#DEFINE LINEERR_UNINITIALIZED  0x80000050
#DEFINE LINEERR_USERUSERINFOTOOBIG  0x80000051
#DEFINE LINEERR_REINIT  0x80000052
#DEFINE LINEERR_ADDRESSBLOCKED  0x80000053
#DEFINE LINEERR_BILLINGREJECTED  0x80000054
#DEFINE LINEERR_INVALFEATURE  0x80000055
#DEFINE LINEERR_NOMULTIPLEINSTANCE  0x80000056
#DEFINE LINEERR_INVALAGENTID  0x80000057 && TAPI v2.0
#DEFINE LINEERR_INVALAGENTGROUP  0x80000058 && TAPI v2.0
#DEFINE LINEERR_INVALPASSWORD  0x80000059 && TAPI v2.0
#DEFINE LINEERR_INVALAGENTSTATE  0x8000005A && TAPI v2.0
#DEFINE LINEERR_INVALAGENTACTIVITY  0x8000005B && TAPI v2.0
#DEFINE LINEERR_DIALVOICEDETECT  0x8000005C && TAPI v2.0

#DEFINE LINEFEATURE_DEVSPECIFIC  0x1
#DEFINE LINEFEATURE_DEVSPECIFICFEAT  0x2
#DEFINE LINEFEATURE_FORWARD  0x4
#DEFINE LINEFEATURE_MAKECALL  0x8
#DEFINE LINEFEATURE_SETMEDIACONTROL  0x10
#DEFINE LINEFEATURE_SETTERMINAL  0x20
#DEFINE LINEFEATURE_SETDEVSTATUS  0x40 && TAPI v2.0
#DEFINE LINEFEATURE_FORWARDFWD  0x80 && TAPI v2.0
#DEFINE LINEFEATURE_FORWARDDND  0x100 && TAPI v2.0

#DEFINE LINEFORWARDMODE_UNCOND  0x1
#DEFINE LINEFORWARDMODE_UNCONDINTERNAL  0x2
#DEFINE LINEFORWARDMODE_UNCONDEXTERNAL  0x4
#DEFINE LINEFORWARDMODE_UNCONDSPECIFIC  0x8
#DEFINE LINEFORWARDMODE_BUSY  0x10
#DEFINE LINEFORWARDMODE_BUSYINTERNAL  0x20
#DEFINE LINEFORWARDMODE_BUSYEXTERNAL  0x40
#DEFINE LINEFORWARDMODE_BUSYSPECIFIC  0x80
#DEFINE LINEFORWARDMODE_NOANSW  0x100
#DEFINE LINEFORWARDMODE_NOANSWINTERNAL  0x200
#DEFINE LINEFORWARDMODE_NOANSWEXTERNAL  0x400
#DEFINE LINEFORWARDMODE_NOANSWSPECIFIC  0x800
#DEFINE LINEFORWARDMODE_BUSYNA  0x1000
#DEFINE LINEFORWARDMODE_BUSYNAINTERNAL  0x2000
#DEFINE LINEFORWARDMODE_BUSYNAEXTERNAL  0x4000
#DEFINE LINEFORWARDMODE_BUSYNASPECIFIC  0x8000
#DEFINE LINEFORWARDMODE_UNKNOWN  0x10000
#DEFINE LINEFORWARDMODE_UNAVAIL  0x20000

#DEFINE LINEGATHERTERM_BUFFERFULL  0x1
#DEFINE LINEGATHERTERM_TERMDIGIT  0x2
#DEFINE LINEGATHERTERM_FIRSTTIMEOUT  0x4
#DEFINE LINEGATHERTERM_INTERTIMEOUT  0x8
#DEFINE LINEGATHERTERM_CANCEL  0x10

#DEFINE LINEGENERATETERM_DONE  0x1
#DEFINE LINEGENERATETERM_CANCEL  0x2

***These constants are mutually exclusive - there's no way to specify more
***than one at a time (and it doesn't make sense, either) so they're
***ordinal rather than bits.
#DEFINE LINEINITIALIZEEXOPTION_USEHIDDENWINDOW  0x1 && TAPI v2.0
#DEFINE LINEINITIALIZEEXOPTION_USEEVENT  0x2 && TAPI v2.0
#DEFINE LINEINITIALIZEEXOPTION_USECOMPLETIONPORT  0x3 && TAPI v2.0
#DEFINE LINEINITIALIZEEXOPTION_CALLHUBTRACKING  0x80000000 && TAPI v3.0

#DEFINE LINEMAPPER  0xFFFF

#DEFINE LINEMEDIACONTROL_NONE  0x1
#DEFINE LINEMEDIACONTROL_START  0x2
#DEFINE LINEMEDIACONTROL_RESET  0x4
#DEFINE LINEMEDIACONTROL_PAUSE  0x8
#DEFINE LINEMEDIACONTROL_RESUME  0x10
#DEFINE LINEMEDIACONTROL_RATEUP  0x20
#DEFINE LINEMEDIACONTROL_RATEDOWN  0x40
#DEFINE LINEMEDIACONTROL_RATENORMAL  0x80
#DEFINE LINEMEDIACONTROL_VOLUMEUP  0x100
#DEFINE LINEMEDIACONTROL_VOLUMEDOWN  0x200
#DEFINE LINEMEDIACONTROL_VOLUMENORMAL  0x400

#DEFINE LINEMEDIAMODE_UNKNOWN  0x2
#DEFINE LINEMEDIAMODE_INTERACTIVEVOICE  0x4
#DEFINE LINEMEDIAMODE_AUTOMATEDVOICE  0x8
#DEFINE LINEMEDIAMODE_DATAMODEM  0x10
#DEFINE LINEMEDIAMODE_G3FAX  0x20
#DEFINE LINEMEDIAMODE_TDD  0x40
#DEFINE LINEMEDIAMODE_G4FAX  0x80
#DEFINE LINEMEDIAMODE_DIGITALDATA  0x100
#DEFINE LINEMEDIAMODE_TELETEX  0x200
#DEFINE LINEMEDIAMODE_VIDEOTEX  0x400
#DEFINE LINEMEDIAMODE_TELEX  0x800
#DEFINE LINEMEDIAMODE_MIXED  0x1000
#DEFINE LINEMEDIAMODE_ADSI  0x2000
#DEFINE LINEMEDIAMODE_VOICEVIEW  0x4000
#DEFINE LINEMEDIAMODE_VIDEO  0x8000 && TAPI v2.1

#DEFINE LAST_LINEMEDIAMODE  0x8000

#DEFINE LINEOPENOPTION_SINGLEADDRESS  0x80000000 && TAPI v2.0
#DEFINE LINEOPENOPTION_PROXY  0x40000000 && TAPI v2.0

#DEFINE LINEPARKMODE_DIRECTED  0x1
#DEFINE LINEPARKMODE_NONDIRECTED  0x2

#DEFINE LINEPROXYREQUEST_SETAGENTGROUP  0x1 && TAPI v2.0
#DEFINE LINEPROXYREQUEST_SETAGENTSTATE  0x2 && TAPI v2.0
#DEFINE LINEPROXYREQUEST_SETAGENTACTIVITY  0x3 && TAPI v2.0
#DEFINE LINEPROXYREQUEST_GETAGENTCAPS  0x4 && TAPI v2.0
#DEFINE LINEPROXYREQUEST_GETAGENTSTATUS  0x5 && TAPI v2.0
#DEFINE LINEPROXYREQUEST_AGENTSPECIFIC  0x6 && TAPI v2.0
#DEFINE LINEPROXYREQUEST_GETAGENTACTIVITYLIST  0x7 && TAPI v2.0
#DEFINE LINEPROXYREQUEST_GETAGENTGROUPLIST  0x8 && TAPI v2.0

#DEFINE LINEPROXYREQUEST_CREATEAGENT  0x9 && TAPI v3.0
#DEFINE LINEPROXYREQUEST_SETAGENTMEASUREMENTPERIOD  0xA && TAPI v3.0
#DEFINE LINEPROXYREQUEST_GETAGENTINFO  0xB && TAPI v3.0
#DEFINE LINEPROXYREQUEST_CREATEAGENTSESSION  0xC && TAPI v3.0
#DEFINE LINEPROXYREQUEST_GETAGENTSESSIONLIST  0xD && TAPI v3.0
#DEFINE LINEPROXYREQUEST_SETAGENTSESSIONSTATE  0xE && TAPI v3.0
#DEFINE LINEPROXYREQUEST_GETAGENTSESSIONINFO  0xF && TAPI v3.0
#DEFINE LINEPROXYREQUEST_GETQUEUELIST  0x10 && TAPI v3.0
#DEFINE LINEPROXYREQUEST_SETQUEUEMEASUREMENTPERIOD  0x11 && TAPI v3.0
#DEFINE LINEPROXYREQUEST_GETQUEUEINFO  0x12 && TAPI v3.0
#DEFINE LINEPROXYREQUEST_GETGROUPLIST  0x13 && TAPI v3.0
#DEFINE LINEPROXYREQUEST_SETAGENTSTATEEX  0x14 && TAPI v3.0

#DEFINE LINEREMOVEFROMCONF_NONE  0x1
#DEFINE LINEREMOVEFROMCONF_LAST  0x2
#DEFINE LINEREMOVEFROMCONF_ANY  0x3

#DEFINE LINEREQUESTMODE_MAKECALL  0x1
#DEFINE LINEREQUESTMODE_MEDIACALL  0x2
#DEFINE LINEREQUESTMODE_DROP  0x4

#DEFINE LAST_LINEREQUESTMODE  0x2

#DEFINE LINEROAMMODE_UNKNOWN  0x1
#DEFINE LINEROAMMODE_UNAVAIL  0x2
#DEFINE LINEROAMMODE_HOME  0x4
#DEFINE LINEROAMMODE_ROAMA  0x8
#DEFINE LINEROAMMODE_ROAMB  0x10

#DEFINE LINESPECIALINFO_NOCIRCUIT  0x1
#DEFINE LINESPECIALINFO_CUSTIRREG  0x2
#DEFINE LINESPECIALINFO_REORDER  0x4
#DEFINE LINESPECIALINFO_UNKNOWN  0x8
#DEFINE LINESPECIALINFO_UNAVAIL  0x10

#DEFINE LINETERMDEV_PHONE  0x1
#DEFINE LINETERMDEV_HEADSET  0x2
#DEFINE LINETERMDEV_SPEAKER  0x4

#DEFINE LINETERMMODE_BUTTONS  0x1
#DEFINE LINETERMMODE_LAMPS  0x2
#DEFINE LINETERMMODE_DISPLAY  0x4
#DEFINE LINETERMMODE_RINGER  0x8
#DEFINE LINETERMMODE_HOOKSWITCH  0x10
#DEFINE LINETERMMODE_MEDIATOLINE  0x20
#DEFINE LINETERMMODE_MEDIAFROMLINE  0x40
#DEFINE LINETERMMODE_MEDIABIDIRECT  0x80

#DEFINE LINETERMSHARING_PRIVATE  0x1
#DEFINE LINETERMSHARING_SHAREDEXCL  0x2
#DEFINE LINETERMSHARING_SHAREDCONF  0x4

#DEFINE LINETONEMODE_CUSTOM  0x1
#DEFINE LINETONEMODE_RINGBACK  0x2
#DEFINE LINETONEMODE_BUSY  0x4
#DEFINE LINETONEMODE_BEEP  0x8
#DEFINE LINETONEMODE_BILLING  0x10

#DEFINE LINETRANSFERMODE_TRANSFER  0x1
#DEFINE LINETRANSFERMODE_CONFERENCE  0x2

#DEFINE LINETOLLLISTOPTION_ADD  0x1
#DEFINE LINETOLLLISTOPTION_REMOVE  0x2

#DEFINE LINETRANSLATEOPTION_CARDOVERRIDE  0x1
#DEFINE LINETRANSLATEOPTION_CANCELCALLWAITING  0x2
#DEFINE LINETRANSLATEOPTION_FORCELOCAL  0x4
#DEFINE LINETRANSLATEOPTION_FORCELD  0x8

#DEFINE LINETRANSLATERESULT_CANONICAL  0x1
#DEFINE LINETRANSLATERESULT_INTERNATIONAL  0x2
#DEFINE LINETRANSLATERESULT_LONGDISTANCE  0x4
#DEFINE LINETRANSLATERESULT_LOCAL  0x8
#DEFINE LINETRANSLATERESULT_INTOLLLIST  0x10
#DEFINE LINETRANSLATERESULT_NOTINTOLLLIST  0x20
#DEFINE LINETRANSLATERESULT_DIALBILLING  0x40
#DEFINE LINETRANSLATERESULT_DIALQUIET  0x80
#DEFINE LINETRANSLATERESULT_DIALDIALTONE  0x100
#DEFINE LINETRANSLATERESULT_DIALPROMPT  0x200
#DEFINE LINETRANSLATERESULT_VOICEDETECT  0x400 && TAPI v2.0

#DEFINE LINELOCATIONOPTION_PULSEDIAL  0x1

#DEFINE PHONEFEATURE_GETBUTTONINFO  0x1 && TAPI v2.0
#DEFINE PHONEFEATURE_GETDATA  0x2 && TAPI v2.0
#DEFINE PHONEFEATURE_GETDISPLAY  0x4 && TAPI v2.0
#DEFINE PHONEFEATURE_GETGAINHANDSET  0x8 && TAPI v2.0
#DEFINE PHONEFEATURE_GETGAINSPEAKER  0x10 && TAPI v2.0
#DEFINE PHONEFEATURE_GETGAINHEADSET  0x20 && TAPI v2.0
#DEFINE PHONEFEATURE_GETHOOKSWITCHHANDSET  0x40 && TAPI v2.0
#DEFINE PHONEFEATURE_GETHOOKSWITCHSPEAKER  0x80 && TAPI v2.0
#DEFINE PHONEFEATURE_GETHOOKSWITCHHEADSET  0x100 && TAPI v2.0
#DEFINE PHONEFEATURE_GETLAMP  0x200 && TAPI v2.0
#DEFINE PHONEFEATURE_GETRING  0x400 && TAPI v2.0
#DEFINE PHONEFEATURE_GETVOLUMEHANDSET  0x800 && TAPI v2.0
#DEFINE PHONEFEATURE_GETVOLUMESPEAKER  0x1000 && TAPI v2.0
#DEFINE PHONEFEATURE_GETVOLUMEHEADSET  0x2000 && TAPI v2.0
#DEFINE PHONEFEATURE_SETBUTTONINFO  0x4000 && TAPI v2.0
#DEFINE PHONEFEATURE_SETDATA  0x8000 && TAPI v2.0
#DEFINE PHONEFEATURE_SETDISPLAY  0x10000 && TAPI v2.0
#DEFINE PHONEFEATURE_SETGAINHANDSET  0x20000 && TAPI v2.0
#DEFINE PHONEFEATURE_SETGAINSPEAKER  0x40000 && TAPI v2.0
#DEFINE PHONEFEATURE_SETGAINHEADSET  0x80000 && TAPI v2.0
#DEFINE PHONEFEATURE_SETHOOKSWITCHHANDSET  0x100000 && TAPI v2.0
#DEFINE PHONEFEATURE_SETHOOKSWITCHSPEAKER  0x200000 && TAPI v2.0
#DEFINE PHONEFEATURE_SETHOOKSWITCHHEADSET  0x400000 && TAPI v2.0
#DEFINE PHONEFEATURE_SETLAMP  0x800000 && TAPI v2.0
#DEFINE PHONEFEATURE_SETRING  0x1000000 && TAPI v2.0
#DEFINE PHONEFEATURE_SETVOLUMEHANDSET  0x2000000 && TAPI v2.0
#DEFINE PHONEFEATURE_SETVOLUMESPEAKER  0x4000000 && TAPI v2.0
#DEFINE PHONEFEATURE_SETVOLUMEHEADSET  0x8000000 && TAPI v2.0

#DEFINE PHONEINITIALIZEEXOPTION_USEHIDDENWINDOW  0x1 && TAPI v2.0
#DEFINE PHONEINITIALIZEEXOPTION_USEEVENT  0x2 && TAPI v2.0
#DEFINE PHONEINITIALIZEEXOPTION_USECOMPLETIONPORT  0x3 && TAPI v2.0

#DEFINE VBTAB	Chr(9)
#define vbCR	Chr(10)
#define vbLF	&& Chr(13)
#define vbCrLf	vbCR

#define Checked		1
#define Unchecked 	0

